extends CanvasLayer
class_name HomeUI

# Home ui class
# Initialize UI components 


#signals 


#enums
# visibility state enum
# used to define object or ui if it visible or not
enum Visibility {
	VISIBLE,
	UNVISIBLE,
}

var _sound_off : bool
var _music_off : bool 


# Variants defenitions 
onready var _coins : Coins = get_node("main/settings_score/coins")
onready var _cur_lvl_cnt : Label = get_node(
	"main/level_progress/current/lvl_nbr/curr_lvl")
onready var _skin_icon : TextureRect = get_node(
	"main/skins/margin/skins_panel/panel_fg/skin_icon")
onready var _show_hide_anim : AnimationPlayer = get_node(
	"main/AnimationPlayer")
onready var _settings_anim : AnimationPlayer = get_node(
	"main/settings_score/settings/AnimationPlayer")
onready var _sound_off_toggle : Panel = get_node(
	"main/settings_score/settings/margin/btn_sound/btn/line")
onready var _music_off_toggle : Panel = get_node(
	"main/settings_score/settings/margin/btn_music/btn/line")


# Built-in methods


func _ready():
	if B4DFramework.get_level() >= 2 and not B4DFramework.b4d_ads.is_banner_visible():
		B4DFramework.b4d_ads.load_banner()
	_show_ui()


func _unhandled_input(event):
	if event is InputEventScreenTouch and event.is_pressed():
		_hide_ui()


# public methods


# Initialize the UI values
func init(coins : int , cur_level : int , coin_icon : Texture ,
	cur_skin : int) -> void:
	
	_coins.init(coins,coin_icon) # Initialize coin holder
	
	_cur_lvl_cnt.set_text("LEVEL " + str(cur_level)) # Set level Lbl
	
	var skin_index : int = B4DFramework.get_skin() - 1
	var cur_skin_text : Texture = B4DFramework.get_skins_textures()[skin_index]
	_skin_icon.texture = cur_skin_text
	
	# Setings btns
	_sound_off_toggle.visible = not B4DFramework.get_settings().sound
	_music_off_toggle.visible = not B4DFramework.get_settings().music
	_sound_off = not B4DFramework.get_settings().sound
	_music_off = not B4DFramework.get_settings().music
	
	B4DFramework.connect("level_completed",self,"_on_level_completed",[],
		CONNECT_ONESHOT)


# private methods
func _on_level_completed() -> void:
	queue_free()


func _show_ui() -> void:
	yield(_show_hide_anim,"animation_finished")
	_show_hide_anim.play_backwards("home_score_skins_disappear")
#	_coins.show()


var _ui_visib : int = Visibility.VISIBLE
func _hide_ui() -> void:
	if _ui_visib == Visibility.UNVISIBLE:
		return
	
	if _show_hide_anim.is_playing():
		yield(_show_hide_anim,"animation_finished")
	_show_hide_anim.play("home_score_skins_disappear")
	_coins.hide()
	_ui_visib = Visibility.UNVISIBLE


var _stngs_visib : int = Visibility.UNVISIBLE
func _on_settings_pressed() -> void:
	if _settings_anim.is_playing():
		return
	
	if _stngs_visib == Visibility.VISIBLE:
		_settings_anim.play_backwards("settings_btns_open")
		_stngs_visib = Visibility.UNVISIBLE
	elif _stngs_visib == Visibility.UNVISIBLE:
		_settings_anim.play("settings_btns_open")
		_stngs_visib = Visibility.VISIBLE
	Sounds.play_tap_sound()


# Show or hide the on_off line
func _on_sound_on_off() -> void:
	if _sound_off:
		
		B4DFramework.set_sound(true)
		
		_sound_off_toggle.visible = false
		_sound_off = false

	else:
		B4DFramework.set_sound(false)
		
		_sound_off_toggle.visible = true
		_sound_off = true
	Sounds.play_tap_sound()


# Show or hide the on_off line
func _on_music_on_off() -> void:
	if _music_off:
		
		B4DFramework.set_music(true)
	
		_music_off_toggle.visible = false
		_music_off = false
	else:
		
		B4DFramework.set_music(false)
		
		_music_off_toggle.visible = true
		_music_off = true
	Sounds.play_tap_sound()


func _on_skins_press() -> void:
	Sounds.play_tap_sound()
	get_tree().change_scene_to(B4DFramework.skins_scn)
